document.addEventListener('DOMContentLoaded', function (event) {

	'use strict';

	// Initialise resize library
	var resize = new window.resize();
	resize.init();

	// Upload photo
	var upload = function (photo, galeria2,idform2, callback) {
		var formData = new FormData();
		formData.append('photo', photo);
		var request = new XMLHttpRequest();
		request.onreadystatechange = function() {
			if (request.readyState === 4) {
				callback(request.response);
			}
		}
		//alert(galeria2);
		//alert(idform2);
		request.open('POST', '?uploadimgs=1&ngaleria='+galeria2+'&upform='+idform2+'');
		request.responseType = 'json';
		request.send(formData);
	};
  
	var fileSize = function (size) {
		var i = Math.floor(Math.log(size) / Math.log(1024));
		return (size / Math.pow(1024, i)).toFixed(2) * 1 + ' ' + ['B', 'kB', 'MB', 'GB', 'TB'][i];
	};

	document.querySelector('input.file123').addEventListener('change', function (event) {
		event.preventDefault();

		var files = event.target.files;
		
		var galeria = $(this).attr('data-galeria');	
		var idform = $(this).attr('data-idform');
		for (var i in files) {

			if (typeof files[i] !== 'object') return false;

			(function () {

				var initialSize = files[i].size;

				resize.photo(files[i], 1920, 'file', function (resizedFile) {

					var resizedSize = resizedFile.size;

					upload(resizedFile,galeria,idform, function (response) {
						var rowElement = document.createElement('tr');
						//rowElement.innerHTML = '<td>'+new Date().getHours()+':'+new Date().getMinutes()+':'+new Date().getSeconds()+'</td><td>'+fileSize(initialSize)+'</td><td>'+fileSize(resizedSize)+'</td><td>'+Math.round((initialSize - resizedSize) / initialSize * 100)+'%</td><td><a href="'+response.url+'">view image</a></td>';
						//document.querySelector('table.images tbody').appendChild(rowElement);
						
						resize.photo(resizedFile, 100, 'dataURL', function (thumbnail) {
						//console.log('Display the thumbnail to the user: ', thumbnail);
						$('.formimagem').append('<div class="col-md-1" style="position:relative;margin-bottom:10px; text-align:center;"><div style=" min-height:50px; position:relative;  border:3px solid #977F52; background: url('+thumbnail+') center top; background-size:cover;"></div>OK <span class="glyphicon glyphicon-ok" aria-hidden="true"></span></div>');  
					});

						
					});

					// This is not used in the demo, but an example which returns a data URL so yan can show the user a thumbnail before uploading th image.
					
				});

			}());

		}

	});

});
